/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.util.dump;

import com.ibm.hwmca.base.util.BaseFileControl;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.util.Trace;
import java.io.IOException;

public class JVMDump {
    private static final String TRACE_MASKT = "XJDMPsJT";
    private static final String TRACE_MASKF = "XJDMPsJF";
    private static final String TRACE_MASKD = "XJDMPsJD";

    public static void dump(String host, int port, String description) throws HException, IOException {
        Trace.trace(TRACE_MASKF, "-> JVMDump.dump(" + host + ", " + port + ", " + description + ")");
        String[] cmdString = new String[]{"jvmdump", "-h", host != null ? host : "localhost", "-p", Integer.toString(port), "-o", BaseFileControl.getFilePath("jvmdumptargetdirectory"), "-l6", "-t", "-d", description != null ? description : "", ">/dev/null", "2>&1"};
        Trace.trace(TRACE_MASKF, "Issuing dump cmd: ");
        for (int i = 0; i < cmdString.length; ++i) {
            Trace.trace(TRACE_MASKF, "  " + cmdString[i]);
        }
        Process process = Runtime.getRuntime().exec(cmdString);
        boolean dumpRunning = true;
        while (dumpRunning) {
            try {
                process.waitFor();
                dumpRunning = false;
                int exitValue = process.exitValue();
                Trace.trace(TRACE_MASKF, "Exit status " + exitValue + " from dumper process ");
                if (exitValue == 0) continue;
                throw new HException("Dump attempt failed.  Exit status " + exitValue + " from dumper process");
            }
            catch (InterruptedException e) {
            }
        }
        Trace.trace(TRACE_MASKF, "<- JVMDump.dump()");
    }

    private JVMDump() {
    }
}

